#!/bin/sh
# ---------------------------------------------------
# Start Script for the Network Data Model Editor
#
# Environment Variable Prerequisites
#
#   ORACLE_HOME     Oracle database installation home.
# ---------------------------------------------------

# Get required environment variables
if [ ! -r "$ORACLE_HOME"/lib/xmlparserv2.jar ]; then
  echo "Cannot find $ORACLE_HOME/lib/xmlparserv2.jar"
  echo "This file is needed to run this program"
  exit 1
fi

if [ ! -r "$ORACLE_HOME"/rdbms/jlib/xdb.jar ]; then
  echo "Cannot find $ORACLE_HOME/rdbms/jlib/xdk.jar"
  echo "This file is needed to run this program"
  exit 1
fi


if [ ! -r "$ORACLE_HOME"/jdbc/lib/ojdbc6.jar ]; then
  echo "Cannot find $ORACLE_HOME/jdbc/lib/ojdbc6.jar"
  echo "This file is needed to run this program"
  exit 1
fi

if [ ! -r "$ORACLE_HOME"/jdk/bin/java ]; then
  echo "Cannot find $ORACLE_HOME/jdk/bin/java"
  echo "This file is needed to run this program"
  exit 1
fi


JARS=$ORACLE_HOME/jdbc/lib/ojdbc6.jar:$ORACLE_HOME/lib/xmlparserv2.jar:$ORACLE_HOME/rdbms/jlib/xdb.jar

# Set the locations for required jar files as appropriate.

JARS="$JARS":$ORACLE_HOME/md/jlib/sdondme.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdoapi.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdonm.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdoutl.jar

JAVA_PARAMS="-Xms512M -Xmx512M"
EDITOR_CLASS=oracle.spatial.network.editor.NetworkEditor

exec $ORACLE_HOME/jdk/bin/java $JAVA_PARAMS -classpath "$JARS" $EDITOR_CLASS









